<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quotation</title>
    <style type="text/css">
        body {
            font-family: 'Poppins', sans-serif;
            position: relative;
            min-height: 100vh;
        }

        .invoice-container {
            background-repeat: no-repeat;
            background-position: top right;
            min-height: calc(100% - 50px);
            background-image: url('storage/images/invoice-AMC.jpg');
        }

        header {
            display: flex;
            margin-bottom: 20px;
        }

        .company-details {
            margin-left: 5px;
        }

        .invoice-image {
            width: 100px;
            height: auto;
            position: absolute;
            top: 20px;
            right: 20px;
        }

        .invoice-details {
            display: flex;
            margin-bottom: 20px;
            margin-top: 0px;
        }

        .bill-to,
        .invoice-number-date {
            width: 48%;
        }

        .invoice-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .invoice-table th,
        .invoice-table td {
            border: 1px solid #000;
            padding: 10px;
            text-align: left;
        }

        .invoice-table th {
            background-color: #f2f2f2;
        }

        .invoice-summary {
            display: flex;
            margin-top: 20px;
        }

        footer {
            text-align: center;
            position: absolute;
            bottom: 0;
            width: 100%;
            padding: 10px;
        }

        .bg-text {
            background-color: #01C681;
            width: fit-content;
            padding: 15px;
            color: #ffffff;
        }

        table tr,
        th,
        td {
            border-bottom: 1px solid #d2d2d2;
            border-collapse: collapse;
            padding: 10px;
        }

        table tr th {
            background: #F4F4F4;
            font-size: 15px;
        }

        table tr td {
            font-size: 13px;
        }

        table {
            border-collapse: collapse;
            width: 98%;
        }

        .box-text p {
            line-height: 10px;
        }

        .float-left {
            float: left;
        }

        .total-part {
            font-size: 16px;
            line-height: 12px;
        }

        .total-right p {
            padding-right: 20px;
        }

        .border-0 {
            border: none;
        }

        .text-gray {
            color: #818386;
        }

        .mt-30 {
            margin-top: 30px;
        }

        .table_heading {
            color: #818386;
        }

        .table_body {
            color: #333333;
        }

        .w-700 {
            font-weight: 700;
        }

        .w-500 {
            font-weight: 500;
        }

        .w-600 {
            font-weight: 600;
        }

        .w-400 {
            font-weight: 400;
        }

        .f-20 {
            font-size: 20px;
        }

        .ms-5 {
            margin-left: 10px;
        }
    </style>
</head>

<body>
    <div class="invoice-container">
        <table>
            <tr class="border-0">
                <td style="width: 100px;" class="border-0">
                    <?php
                    $imageUrl = url('storage/' . $setting->logo);
                    ?>
                    <img src="<?php echo $imageUrl; ?>" alt="Company Logo" width="150px">
                </td>
                <td class="border-0">
                    <h3><?php echo $setting->system_name; ?></h3>
                    <p><span class="text-gray w-600">EMAIL: </span><span
                            class="w-400"><?php echo $setting->email; ?></span></p>
                    <p><span class="text-gray w-600">ADDRESS: </span><span
                            class="w-400"><?php echo $setting->address; ?></span></p>
                </td>
            </tr>
        </table>
        <table class="mt-30">
            <tr class="border-0">
                <td class="border-0" style="width: 430px;">
                    <span class="w-500 f-20">Bill to: <?php echo $data->customer->full_name ?></span>
                    <p><span class="text-gray w-600">COMAPNY NAME: </span><span
                            class="w-400"><?php echo $data->customer->company_name ?></span></p>
                    <p><span class="text-gray w-600">EMAIL: </span><span
                            class="w-400"><?php echo $data->customer->email ?></span></p>
                    <p><span class="text-gray w-600">MOBILE: </span><span class="w-400"><?php
                    $countryCode = getSetting('country');
                    $mobile = $data->customer->mobile;
                    echo '+' . $countryCode . ' ' . $mobile;
                    ?></span></p>
                </td>
                <td class="border-0">
                    <p style="margin-bottom: 30px;"><span class="bg-text w-700">QUOTATION :
                            <?php echo $data->quotation_no; ?></span></p>
                    <p><span class="text-gray w-600">DATE: </span><span
                            class="w-700"><?php echo formatDate($data->date); ?></span></p>
                </td>
            </tr>
        </table>
        <table class="table mt-30 ms-5">
            <p class="w-500 f-20">Quotation Details</p>

            <tr style="background: #F2F2F2;">
                <th class="table_heading">#</th>
                <th class="table_heading">Product Name</th>
                <th class="table_heading">Price</th>
                <th class="table_heading">Qty</th>
                <th class="table_heading">Amount</th>
            </tr>
            <?php
            $i = 1;
            foreach ($data->productDetails as $product) {
                ?>
                <tr align="center">
                    <td class="table_body"><?php echo $i; ?></td>
                    <td class="table_body"><?php echo $product->product->name; ?></td>
                    <td class="table_body"><span
                            style="font-family: DejaVu Sans; sans-serif;"><?php echo getSetting('currency_code'); ?></span><?php echo number_format($product->rate, 2, '.', ''); ?>
                    </td>
                    <td class="table_body"><?php echo $product->quantity; ?></td>
                    <td class="table_body"><span
                            style="font-family: DejaVu Sans; sans-serif;"><?php echo getSetting('currency_code'); ?></span><?php echo number_format($product->amount, 2, '.', ''); ?>
                    </td>
                </tr>
                <?php $i++;
            } ?>
            <tr class="border-0">
                <td colspan="5" class="border-0">
                    <div class="total-part">
                        <div class="total-left w-90 float-right" align="right" style="padding-right:45px;">
                            <p><span class="text-gray w-500">Sub Total : </span><span
                                    style="font-family: DejaVu Sans; sans-serif;"><?php echo getSetting('currency_code'); ?></span><span
                                    class="w-700"><?php echo number_format($data->sub_total, 2, '.', ''); ?></span></p>
                            <?php
                            foreach ($taxes as $tax) {
                                echo "<p><span style='color: gray; font-weight:500;'>{$tax['label']}({$tax['percentage']}%) : </span> <span style='font-weight: 700;'>+ <span style='font-family: DejaVu Sans; sans-serif;'>" . getSetting('currency_code') . "</span>" . number_format($tax['tax_amount'], 2, '.', '') . "</span></p>";
                            }
                            ?>
                            <p style="margin-top: 30px;"><span class="bg-text w-700"> Grand Total : <span
                                        style="font-family: DejaVu Sans; sans-serif;"><?php echo getSetting('currency_code'); ?></span><?php echo number_format($data->gross_total, 2, '.', ''); ?>
                                </span></p>
                        </div>

                        <div style="clear: both;"></div>
                    </div>
                </td>
            </tr>
        </table>
    </div>
    <footer>
        <p><?php echo $setting->footer_text; ?> - <?php echo $setting->starting_year; ?></p>
    </footer>
</body>

</html>