<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

use App\Models\Category;

class CategorySeeder extends Seeder
{
        /**
         * Run the database seeds.
         *
         * @return void
         */
        public function run()
        {
                \App\Models\Category::create(['key' => 'product_category', 'value' => 'Computer']);
                \App\Models\Category::create(['key' => 'product_category', 'value' => 'Mobile']);
                \App\Models\Category::create(['key' => 'product_category', 'value' => 'Laptop']);
                \App\Models\Category::create(['key' => 'product_category', 'value' => 'TV']);
                \App\Models\Category::create(['key' => 'product_category', 'value' => 'A/C']);
                \App\Models\Category::create(['key' => 'product_brand', 'value' => 'Moto']);
                \App\Models\Category::create(['key' => 'product_brand', 'value' => 'Apple']);
                \App\Models\Category::create(['key' => 'product_brand', 'value' => 'MI']);
                \App\Models\Category::create(['key' => 'product_brand', 'value' => 'Nokia']);
                \App\Models\Category::create(['key' => 'product_brand', 'value' => 'Sony']);
                \App\Models\Category::create(['key' => 'unit', 'value' => 'KG']);
                \App\Models\Category::create(['key' => 'unit', 'value' => 'Count']);
                \App\Models\Category::create(['key' => 'unit', 'value' => 'Liter']);
                \App\Models\Category::create(['key' => 'amc_status', 'value' => 'open']);
                \App\Models\Category::create(['key' => 'amc_status', 'value' => 'progress']);
                \App\Models\Category::create(['key' => 'amc_status', 'value' => 'closed']);
                \App\Models\Category::create(['key' => 'service_status', 'value' => 'open']);
                \App\Models\Category::create(['key' => 'service_status', 'value' => 'progress']);
                \App\Models\Category::create(['key' => 'service_status', 'value' => 'closed']);
                \App\Models\Category::create(['key' => 'purchase_status', 'value' => 'ordered']);
                \App\Models\Category::create(['key' => 'purchase_status', 'value' => 'delivered']);
                \App\Models\Category::create(['key' => 'quotation_status', 'value' => 'open']);
                \App\Models\Category::create(['key' => 'quotation_status', 'value' => 'pending']);
                \App\Models\Category::create(['key' => 'quotation_status', 'value' => 'closed']);
                \App\Models\Category::create(['key' => 'sales_status', 'value' => 'paid']);
                \App\Models\Category::create(['key' => 'sales_status', 'value' => 'partial paid']);
                \App\Models\Category::create(['key' => 'sales_status', 'value' => 'unpaid']);
                \App\Models\Category::create(['key' => 'complaint_status', 'value' => 'open']);
                \App\Models\Category::create(['key' => 'complaint_status', 'value' => 'progress']);
                \App\Models\Category::create(['key' => 'complaint_status', 'value' => 'closed']);
                \App\Models\Category::create(['key' => 'complaint_type', 'value' => 'repair']);
                \App\Models\Category::create(['key' => 'complaint_type', 'value' => 'replace']);

                \App\Models\Category::create(['key' => 'task_status', 'value' => 'open']);
                \App\Models\Category::create(['key' => 'task_status', 'value' => 'progress']);
                \App\Models\Category::create(['key' => 'task_status', 'value' => 'closed']);
                \App\Models\Category::create(['key' => 'task_type', 'value' => 'setup']);
                \App\Models\Category::create(['key' => 'task_type', 'value' => 'repair']);
                \App\Models\Category::create(['key' => 'task_type', 'value' => 'replace']);
                \App\Models\Category::create(['key' => 'income_status', 'value' => 'paid']);
                \App\Models\Category::create(['key' => 'income_status', 'value' => 'partial paid']);
                \App\Models\Category::create(['key' => 'income_status', 'value' => 'unpaid']);
                \App\Models\Category::create(['key' => 'expense_status', 'value' => 'paid']);
                \App\Models\Category::create(['key' => 'expense_status', 'value' => 'partial paid']);
                \App\Models\Category::create(['key' => 'expense_status', 'value' => 'unpaid']);

                $category = \App\Models\Category::create(['key' => 'email_template_types', 'value' => 'registration']);
                \App\Models\EmailTemplate::create(['template_type_id' => $category->id, 'subject' => 'Registration email', 'body' => 'Dear { user_name },

                You are successfully registered at { system_name } as role { role }
       username: { username }
       password: { password }  
       
       Regards, 
       { system_name }.']);

                $category = \App\Models\Category::create(['key' => 'email_template_types', 'value' => 'sales']);
                \App\Models\EmailTemplate::create(['template_type_id' => $category->id, 'subject' => 'Sales Email Notification', 'body' => 'Dear { username },

                Thank You for your recent business with us. Please Find attached a detailed copy of invoice for your Perusal. 
       
       
       Regards From { systemname }.']);

                $category = \App\Models\Category::create(['key' => 'email_template_types', 'value' => 'quotation']);
                \App\Models\EmailTemplate::create(['template_type_id' => $category->id, 'subject' => 'Quotation Invoice', 'body' => 'Dear { username },

                Thank You for your recent business with us. Please Find attached a detailed copy of Quotation for  for your Perusal. 
       
       Regards,
       { systemname }.']);

                $category = \App\Models\Category::create(['key' => 'email_template_types', 'value' => 'complaint_customer']);
                \App\Models\EmailTemplate::create(['template_type_id' => $category->id, 'subject' => 'Complain add by the customer', 'body' => 'Dear { username },

                Thank you for submiting Complaint.Your complaint Number is { complaint_number }
      
      Regards,
      { systemname }.']);

                $category = \App\Models\Category::create(['key' => 'email_template_types', 'value' => 'complaint_admin']);
                \App\Models\EmailTemplate::create(['template_type_id' => $category->id, 'subject' => 'Customer complain added by the admin', 'body' => 'Dear { admin },

                { customer } is submited Complaint. Complaint Number is { complaint_number }
       
       Regards,
       { systemname }.']);

                $category = \App\Models\Category::create(['key' => 'email_template_types', 'value' => 'complaint_employee']);
                \App\Models\EmailTemplate::create(['template_type_id' => $category->id, 'subject' => 'Complain assigned', 'body' => 'Dear { employee },

                You have assigned new Complaint from  { customer }. Complaint Number is { complaint_number } on { complaint_date }
       
       Regards,
       { systemname }.']);

                $category = \App\Models\Category::create(['key' => 'email_template_types', 'value' => 'complaint_resolve_customer']);
                \App\Models\EmailTemplate::create(['template_type_id' => $category->id, 'subject' => 'Complain status update', 'body' => 'Dear { username },


                Your  complain { complaint_number } status is { complaint_status }
     
     
     Regards,
     { systemname }.']);

                $category = \App\Models\Category::create(['key' => 'email_template_types', 'value' => 'service_list_monthly']);
                \App\Models\EmailTemplate::create(['template_type_id' => $category->id, 'subject' => 'Monthly service list', 'body' => 'Dear { admin },

                Monthly Services list attached..
       
       
        { service_list }
       
       
       Regards,
       { systemname }.']);

                $category = \App\Models\Category::create(['key' => 'email_template_types', 'value' => 'service_before_day']);
                \App\Models\EmailTemplate::create(['template_type_id' => $category->id, 'subject' => 'Service reminder', 'body' => 'Dear { username },

                Your Pre approved { service_title } services is Coming up on { service_date }.  This is Just a Reminder mail.
       
       Regards From { systemname }.']);

                $category = \App\Models\Category::create(['key' => 'email_template_types', 'value' => 'service_done_mail']);
                \App\Models\EmailTemplate::create(['template_type_id' => $category->id, 'subject' => 'Service status update', 'body' => 'Dear { username },

                Your services { service_title }  status is { service_status } on { service_date }.
       
       
       Regards From { systemname }.']);

                $category = \App\Models\Category::create(['key' => 'email_template_types', 'value' => 'employee_task_list']);
                \App\Models\EmailTemplate::create(['template_type_id' => $category->id, 'subject' => 'Task assigned', 'body' => 'Dear { employee },

                Here is the list of tasks assigned to you for { today_date }
        { task_list }
       
       Regards,
       { systemname }.']);

                $category = \App\Models\Category::create(['key' => 'email_template_types', 'value' => 'reset_password']);
                \App\Models\EmailTemplate::create(['template_type_id' => $category->id, 'subject' => 'Reset Password', 'body' => 'Dear { name },

                To reset your password { link }.
        
        
        Regards,
        { systemname }']);
        }
}
