<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RemoveTimestampsFromNotificationsAndActivityLogs extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('notifications', function (Blueprint $table) {
            // Remove the automatic timestamps
            $table->dropTimestamps();
        });
        Schema::table('activity_logs', function (Blueprint $table) {
            // Remove the automatic timestamps
            $table->dropTimestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('notifications', function (Blueprint $table) {
            // Re-add the timestamps if rolling back
            $table->timestamps();
        });
        Schema::table('activity_logs', function (Blueprint $table) {
            // Re-add the timestamps if rolling back
            $table->timestamps();
        });
    }
}
