<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tasks', function (Blueprint $table) {
            $table->id();
            $table->longText('customer_id')->nullable();
            $table->longText('assign_to_id')->nullable();
            $table->longText('date')->nullable();
            $table->longText('assign_date')->nullable();
            $table->longText('status_id')->nullable();
            $table->longText('task_type_id')->nullable();
            $table->longText('description')->nullable();
            $table->longText('task_no')->nullable();
            $table->dateTime('status_update_date')->nullable();
            $table->longText('attachment')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('created_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tasks');
    }
};
