<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->longText('address')->nullable();
            $table->longText('email')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('created_at')->nullable();
            $table->longText('country')->nullable();
            $table->longText('currency_code')->nullable();
            $table->longText('date_formate')->nullable();
            $table->longText('footer_text')->nullable();
            $table->longText('office_phone_number')->nullable();
            $table->longText('rtl')->nullable();
            $table->longText('starting_year')->nullable();
            $table->longText('system_language')->nullable();
            $table->longText('system_name')->nullable();
            $table->longText('sidebar_logo')->nullable();
            $table->string('time_zone')->nullable();
            $table->longText('logo')->nullable();
            $table->longText('daily_reminder_last_date')->nullable();
            $table->longText('monthly_reminder_last_date')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
};
