<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quotations', function (Blueprint $table) {
            $table->id();
            $table->longText('customer_id')->nullable();
            $table->longText('date')->nullable();
            $table->longText('status_id')->nullable();
            $table->longText('quotation_no')->nullable();
            $table->longText('details')->nullable();
            $table->double('gross_total')->nullable();
            $table->integer('sub_total')->nullable();
            $table->double('tax_amount')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('created_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quotations');
    }
};
