<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('complaints', function (Blueprint $table) {
            $table->id();
            $table->longText('status_id')->nullable();
            $table->longText('date')->nullable();
            $table->longText('complaint_type_id')->nullable();
            $table->longText('description')->nullable();
            $table->longText('product_id')->nullable();
            $table->longText('assign_to_id')->nullable();
            $table->time('complaint_time')->nullable();
            $table->date('assign_date')->nullable();
            $table->longText('customer_id')->nullable();
            $table->longText('complaint_no')->nullable();
            $table->longText('attachment')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('created_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('complaints');
    }
};
