<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('amcs', function (Blueprint $table) {
            $table->id();
            $table->longText('customer')->nullable();
            $table->longText('date')->nullable();
            $table->longText('contact_person')->nullable();
            $table->longText('status')->nullable();
            $table->longText('assign_to')->nullable();
            $table->longText('amc_detail')->nullable();
            $table->longText('interval')->nullable();
            $table->longText('number_of_service')->nullable();
            $table->longText('amc_no')->nullable();
            $table->longText('employee_status')->nullable();
            $table->boolean('is_employee_status_approved')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('created_at')->nullable();
            $table->longText('attachment')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('amcs');
    }
};
