<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('amc_services', function (Blueprint $table) {
            $table->id();
            $table->longText('amc_id')->nullable();
            $table->date('service_date')->nullable();
            $table->longText('service_label')->nullable();
            $table->longText('status')->nullable();
            $table->longText('assign_to')->nullable();
            $table->boolean('is_chargeble')->nullable();
            $table->time('service_time')->nullable();
            $table->integer('charge')->nullable();
            $table->longText('service_no')->nullable();
            $table->longText('employee_status')->nullable();
            $table->boolean('is_employee_status_approved')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('created_at')->nullable();
            $table->longText('remark')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('amc_services');
    }
};
