<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model as Eloquent;

class Task extends Eloquent
{
    public const TASK_CREATE_ACTIVITY = 'Task Created';
    public const TASK_UPDATE_ACTIVITY = 'Task Updated';
    public const TASK_DELETE_ACTIVITY = 'Task Deleted';
    public const TASK_PATH = '/task/list';
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'task_no', 'customer_id', 'date', 'assign_date', 'assign_to_id', 'task_type_id', 'description', 'attachment', 'status_id', 'status_update_date'
    ];

    protected $dates = [
        'date'  => 'datetime:Y-m-d',
        'assign_date'  => 'datetime:Y-m-d',
        'status_update_date'  => 'datetime:Y-m-d'
    ];

    protected static function booted()
    {
        static::creating(function ($task) {
            $task->task_no = $task->generateUniqueIdentity();
        });
    }

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function taskType()
    {
        return $this->belongsTo(Category::class, 'task_type_id');
    }

    public function status()
    {
        return $this->belongsTo(Category::class, 'status_id');
    }

    public function employeeStatus()
    {
        return $this->belongsTo(Category::class, 'employee_status_id');
    }

    public function employee()
    {
        return $this->belongsTo(User::class, 'assign_to_id');
    }

    public function generateUniqueIdentity()
    {
        $data = $this->select(['task_no'])->orderBy('created_at', 'desc')->first();
        $prefix = 'T-';
        if (!empty($data->task_no)) {


            $split = explode("-", $data->task_no);
            $find = sizeof($split) - 1;
            $last_id = $split[$find];
            $number = intval($last_id) + 1;
            $new_no = sprintf('%06d', $number);
            $uniqID = $prefix . $new_no;
            return $uniqID;
        } else {
            return $prefix . '000001';
        }
    }
}
