<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model as Eloquent;

class ServiceProduct extends Eloquent
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'service_product', 'product_note'
    ];

    public function service()
    {
        return $this->belongsTo(AmcService::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'service_product');
    }
}
