<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model as Eloquent;

class SaleProducts extends Eloquent
{
    protected $fillable = [
        'product_id', 'quantity', 'rate', 'amount'
    ];

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }

    public function sale()
    {
        return $this->belongsTo(Sale::class);
    }
}
