<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model as Eloquent;

class PurchaseProducts extends Eloquent
{
    protected $fillable = [
        'product_id', 'quantity', 'rate', 'amount'
    ];

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }

    public function purchase()
    {
        return $this->belongsTo(Purchase::class);
    }

    public function stock()
    {
        return $this->hasOne(Stock::class, 'product_id', 'product_id');
    }
}
