<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Expense extends Model
{
    public const EXPENSE_CREATE_ACTIVITY = 'Expense Created';
    public const EXPENSE_UPDATE_ACTIVITY = 'Expense Updated';
    public const EXPENSE_DELETE_ACTIVITY = 'Expense Deleted';
    
    protected $fillable = [
        "customer_id",
        "status_id",
        "date",
        "label",
        "entries",
    ];

    protected $dates = [
        "date"
    ];

    public function customer()
    {
        return $this->belongsTo(User::class, "customer_id");
    }

    public function status()
    {
        return $this->belongsTo(Category::class, 'status_id');
    }
}
