<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model as Eloquent;

class AmcService extends Eloquent
{
    public const SERVICE_CREATE_ACTIVITY = 'Service Created';
    public const SERVICE_UPDATE_ACTIVITY = 'Service Updated';
    public const SERVICE_DELETE_ACTIVITY = 'Service Deleted';
    public const SERVICE_PATH = '/service/list';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'service_no', 'service_date', 'service_time', 'service_label', 'assign_to', 'status', 'employee_status', 'is_employee_status_approved', 'amc_id', 'is_chargeble', 'charge', 'remark'
    ];

    protected $dates = [
        'service_date'  => 'datetime:Y-m-d',
        'service_time'
    ];

    protected static function booted()
    {
        static::creating(function ($service) {
            $service->service_no = $service->generateUniqueIdentity();
            $service->employee_status = request()->status;
            $service->is_employee_status_approved = false;
        });
    }

    public function amc()
    {
        return $this->belongsTo(Amc::class);
    }

    public function products()
    {
        return $this->hasMany(ServiceProduct::class);
    }

    public function serviceStatus()
    {
        return $this->belongsTo(Category::class, 'status');
    }

    public function staffStatus()
    {
        return $this->belongsTo(Category::class, 'employee_status');
    }

    public function employee()
    {
        return $this->belongsTo(User::class, 'assign_to');
    }

    public function generateUniqueIdentity()
    {
        $latestService = $this->orderBy('id', 'desc')->first();
        $prefix = 'SV-';

        if ($latestService) {
            $lastNumber = intval(substr($latestService->service_no, 3));
            $newNumber = $lastNumber + 1;
        } else {
            $newNumber = 1;
        }

        return $prefix . str_pad($newNumber, 6, '0', STR_PAD_LEFT);
    }
}
