<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model as Eloquent;

class AmcProduct extends Eloquent
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'amc_product', 'product_note'
    ];

    public function amc()
    {
        return $this->belongsTo(Amc::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'amc_product');
    }
}
