<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SaleInvoice extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $mailData;


    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($mailData)
    {
        $this->mailData = $mailData;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $subject = $this->mailData['subject'];
        // return $this->subject($subject)->with('mailData', $this->mailData)->view('SaleInvoice')->attachData($this->mailData['attachement'], "Invoice.pdf");
        return $this->subject($subject)->with('mailData', $this->mailData)
            ->view('SaleInvoice')
            ->attachFromStorageDisk('public', $this->mailData['attachementPath'], "invoice.pdf", [
                'mime' => 'application/pdf'
            ]);
    }
}
