<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class UserpluckResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $role = $request->input('role');

        $name = $this->full_name;
        if ($role === 'all') {
            $name .= ' (' . $this->getRole() . ')';
        }

        return [
            'id'=>$this->id,
            'name' => $name,
            'email' => $this->email,
        ];
    }
}
