<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class TaskResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'task_no' => ($this->task_no) ? $this->task_no : null,
            'date' => ($this->date) ? getDateF($this->date) : null,
            'assign_date' => ($this->assign_date) ? getDateF($this->assign_date) : null,
            'description' => ($this->description) ? $this->description : null,
            'attachment' => ($this->attachment) ?  url('storage/' . $this->attachment) : url('storage/images/amc/amc.jpg'),
            'task_type_id' => ($this->task_type_id) ? $this->task_type_id : null,
            'task_type' => ($this->taskType) ? $this->taskType->value : null,
            'status_id' => ($this->status_id) ? $this->status_id : null,
            'status' => ($this->status) ? $this->status->value : null,
            'customer_id' => ($this->customer_id) ? $this->customer_id : null,
            'customer' => ($this->customer) ? new UserResource($this->customer) : null,
            'assign_to_id' => ($this->assign_to_id) ? $this->assign_to_id : null,
            'assignTo' => ($this->employee) ? new UserResource($this->employee) : null,
        ];
    }
}
