<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class SidemenuResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $sidemenu = [
            'Dashboard' => ['view_status' => $this->permissions->contains('name', 'dashboard_view')],
            'Users' => ['view_status' => $this->permissions->contains('name', 'user_view')],
            'Product' => ['view_status' => $this->permissions->contains('name', 'product_view')],
            'Purchase' => ['view_status' => $this->permissions->contains('name', 'purchase_view')],
            'Stock' => ['view_status' => $this->permissions->contains('name', 'stock_view')],
            'AMC' => ['view_status' => $this->permissions->contains('name', 'amc_view')],
            'Services' => ['view_status' => $this->permissions->contains('name', 'service_view')],
            'Complaints' => ['view_status' => $this->permissions->contains('name', 'complaint_view')],
            'Quotations' => ['view_status' => $this->permissions->contains('name', 'quotation_view')],
            'Sell' => ['view_status' => $this->permissions->contains('name', 'sell_view')],
            'Income' => ['view_status' => $this->permissions->contains('name', 'income_view')],
            'Expense' => ['view_status' => $this->permissions->contains('name', 'expense_view')],
            'Tax' => ['view_status' => $this->permissions->contains('name', 'tax_view')],
            'Task' => ['view_status' => $this->permissions->contains('name', 'task_view')],
            'Reports' => ['view_status' => $this->permissions->contains('name', 'report_view')],
            'Income' => ['view_status' => $this->permissions->contains('name', 'income_view')],
            'Email Template' => ['view_status' => $this->permissions->contains('name', 'email_template_view')],
            'Settings' => ['view_status' => $this->permissions->contains('name', 'setting_view')],
            'Access Rights' => ['view_status' => false],
            'Activity Logs' => ['view_status' => false],
            'Messages' => ['view_status' => $this->permissions->contains('name', 'message_view')],
        ];

        if ($this->name === 'admin') {
            foreach ($sidemenu as &$menu) {
                $menu['view_status'] = true;
            }
        }

        return [
            'id' => $this->id,
            'name' => $this->name,
            'permissions' => $sidemenu,
        ];
    }
}
