<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class QuotationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'quotation_no' => ($this->quotation_no) ? $this->quotation_no : null,
            'date' => ($this->date) ? getDateF($this->date) : null,
            'status_id' => ($this->status_id) ? $this->status_id : null,
            'status' => ($this->status) ? $this->status->value : null,
            'details' => ($this->details) ? $this->details : null,
            'sub_total' => ($this->sub_total) ? $this->sub_total : null,
            'tax_amount' => ($this->tax_amount) ? $this->tax_amount : null,
            'gross_total' => ($this->gross_total) ? $this->gross_total : null,
            'customer_id' => ($this->customer_id) ? $this->customer_id : null,
            'customer' => ($this->customer) ? new UserResource($this->customer) : null,
            'taxes' => ($this->taxes) ? TaxResource::collection($this->taxes) : '',
            'products' => ($this->productDetails) ? QuotationProductResource::collection($this->productDetails) : null,
            'invoice_url' => url('storage/invoice/quotation-' . $this->id . '.pdf')
        ];
    }
}
