<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class NextServiceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'service_no' => ($this->service_no)?$this->service_no:null,
            'service_date' => ($this->service_date)?getDateF($this->service_date):null,
            'service_label' => ($this->service_label != "null")?$this->service_label:'',
            'amc_id' => ($this->amc_id)?$this->amc_id:null,
            'status_id' => ($this->status)?$this->status:null,
            'status' => ($this->serviceStatus)?$this->serviceStatus->value:null,
            'employee_status_id' => ($this->employee_status)?$this->employee_status:null,
            'employee_status' => ($this->staffStatus)?ucfirst($this->staffStatus->value):null,
            'is_employee_status_approved' => ($this->is_employee_status_approved)?$this->is_employee_status_approved:false,
            'assign_to_id' => ($this->assign_to)?$this->assign_to:null,
            'assignTo' => ($this->employee)?new UserResource($this->employee):null,
            'is_chargeble' => ($this->is_chargeble)?$this->is_chargeble:null,
            'charge' => ($this->charge)?$this->charge:null,
            'remark' => ($this->remark)?$this->remark:null,
            'service_product' => ($this->products)?AmcProductResource::collection($this->products):null,
        ];
    }
}
