<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Http\Resources\Json\ResourceCollection;

class ModuleResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'tag' => $this->tag,
            'permissions' => [
                'view' => $this->view == 1 ? true : false,
                'delete' => $this->delete == 1 ? true : false,
                'add' => $this->add == 1 ? true : false,
                'edit' => $this->edit == 1 ? true : false,
                'own_data' => $this->own_data == 1 ? true : false,
            ],
        ];
    }   
}
