<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class IncomeMonthlyReportResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $entries = collect(json_decode($this->entries));
        $totalIncome = $entries->sum('amount');
        return [
            "id" => $this->id,
            "label" => $this->label,
            "date" => $this->date->format('d-m-Y'),
            "total_income" => $totalIncome,
            "customer_id" => $this->customer_id,
            "customer" => ($this->customer)?$this->customer->full_name:'',
            "status" => $this->status,
            'status_id' => $this->status_id,
            'status' => ($this->status_id) ? new CategoryResource($this->status) : null,
        ];
    }
}
