<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class IncomeListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "customer_id" => $this->customer_id,
            "customer" => ($this->customer)?$this->customer->full_name:'',
            "status" => $this->status,
            'status_id' => $this->status_id,
            'status' => ($this->status_id) ? new CategoryResource($this->status) : null,
            "date" => $this->date->format('d-m-Y'),
            "label" => $this->label,
            "amount" => ($this->entries)?array_sum(array_column(json_decode($this->entries),'amount')):0,
            "entries" => json_decode($this->entries),
        ];
    }
}
