<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class DashboardServiceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'customer_name' => ($this->amc) ? (($this->amc->client) ? $this->amc->client->full_name : 'N/A') : 'N/A',
            'customer_mobile' => ($this->amc) ? (($this->amc->client) ? $this->amc->client->mobile : 'N/A') : 'N/A',
            'customer_profile' => ($this->amc && $this->amc->client) ? (($this->amc->client->profile) ? url('storage/' . $this->amc->client->profile) : url('storage/images/user/' . $this->amc->client->gender . '.jpg')) : 'N/A',
            'service_label' => $this->service_label,
            'service_date' => ($this->service_date) ? getDateF($this->service_date) : null,
            'employee_status' => ($this->staffStatus) ? ucfirst($this->staffStatus->value) : null,
            'assign_to' => ($this->employee) ? $this->employee->full_name : null,
        ];
    }
}
