<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ConversationMessageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {         
        return [
            'id' => $this->id,
            'conversation_id' => $this->conversation_id,
            'subject' => $this->subject,
            'attachment' => ($this->attachment) ?  url('storage/' . $this->attachment) : url('storage/images/service/noimage.png'),
            'message_comment' => $this->message_comment,
            'created_by' => $this->sender->full_name,
            // 'read_by' => $this->read_by,
            // 'deleted_by' => $this->deleted_by,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
