<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AmcBasicResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'amc_no' => $this->amc_no,
            'customer_id' => ($this->customer) ? $this->customer : null,
            'customer' => ($this->client) ? new UserResource($this->client) : null,
            'assign_to_id' => ($this->assign_to) ? $this->assign_to : null,
            'assignTo' => ($this->employee) ? new UserResource($this->employee) : null,
            'date' => getDateF($this->date),
            'next_service' => ($this->next_service) ? new NextServiceResource($this->next_service) : null,
            'contact_person' => $this->contact_person,
            'status_id' => ($this->status) ? $this->status : null,
            'status' => ($this->amcStatus) ? $this->amcStatus->value : null,
            'employee_status_id' => ($this->employee_status) ? $this->employee_status : null,
            'employee_status' => ($this->staffStatus) ? $this->staffStatus->value : null,
            'is_employee_status_approved' => ($this->is_employee_status_approved) ? $this->is_employee_status_approved : false,
            'attachment' => ($this->attachment) ?  url('storage/' . $this->attachment) : url('storage/images/amc/amc.jpg'),
            'amc_detail' => $this->amc_detail,
            'interval' => $this->interval,
            'interval_label' => $this->interval . " Month",
            'number_of_service' => $this->number_of_service,
            // 'amc_services' => ($this->services)?AmcServiceResource::collection($this->services):null,
            // 'amc_product' => ($this->products)?AmcProductResource::collection($this->products):null
        ];
    }
}
