<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\Setting;

class TimeZoneMiddleware
{
    public function handle($request, Closure $next)
    {
        try {
            $setting = Setting::first();
        
            $timeZone = $setting->time_zone ?? 'UTC';
        } catch (\Exception $e) {
            $timeZone = 'UTC';
        }

        date_default_timezone_set($timeZone);
        
        return $next($request);
    }
}