<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Amc;
use App\Models\Complaint;
use App\Models\Quotation;
use App\Models\Product;
use App\Models\Purchase;
use App\Models\AmcService;
use App\Http\Resources\DashboardServiceResource;
use App\Http\Resources\DashboardComplaintResource;
use App\Models\Sale;
use App\Models\Task;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use App\Http\Resources\SidemenuResource;
use Tymon\JWTAuth\Exceptions\UserNotDefinedException;

class DashboardController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {
            if (auth()->user()->getRole() == 'admin' || auth()->user()->hasPermissionTo('dashboard_view')) {

                $monthStart = Carbon::now()->startOfMonth()->format('Y-m-d');
                $monthEnd = Carbon::now()->endOfMonth()->format('Y-m-d');

                // Role wise dashboard data
                if (auth()->user()->getRole() == 'customer') {
                    $weeklyComplaintData = $this->getWeeklyComplaintData();
                    $weeklyServiceData = $this->getWeeklyServiceData();
                    // All Complaint count
                    $allComplaintCount = Complaint::where(['customer_id' => auth()->user()->id])->count();

                    // Open Complaint count
                    $openComplaintCount = Complaint::where(['customer_id' => auth()->user()->id])->whereHas('status', function ($q) {
                        $q->where(['value' => 'open']);
                    })->count();

                    // Inprogress complaint count    
                    $progressComplaintCount = Complaint::where(['customer_id' => auth()->user()->id])->whereHas('status', function ($q) {
                        $q->where(['value' => 'progress']);
                    })->count();

                    // Closed complaint count
                    $closedComplaintCount = Complaint::where(['customer_id' => auth()->user()->id])->whereHas('status', function ($q) {
                        $q->where(['value' => 'closed']);
                    })->count();

                    // All Quotation count
                    $allQuotationCount = Quotation::where(['customer_id' => auth()->user()->id])->count();

                    //All purchase count
                    $allSaleCount = Sale::where(['customer_id' => auth()->user()->id])->count();

                    // Recent complain list
                    $recentComplaints = Complaint::where(['customer_id' => auth()->user()->id])->take(6)->Orderby('created_at', 'desc')->get();

                    // Smart Summary Data

                    // All Service count
                    $allServiceCount = AmcService::whereHas('amc', function ($q) {
                        $q->where(['customer' => auth()->user()->id]);
                    })->count();

                    // Open Service count
                    $openServiceCount = AmcService::whereHas('serviceStatus', function ($q) {
                        $q->where(['value' => 'open']);
                    })->whereHas('amc', function ($q) {
                        $q->where(['customer' => auth()->user()->id]);
                    })->count();

                    // Inprogress Service count    
                    $progressServiceCount = AmcService::whereHas('serviceStatus', function ($q) {
                        $q->where(['value' => 'progress']);
                    })->whereHas('amc', function ($q) {
                        $q->where(['customer' => auth()->user()->id]);
                    })->count();

                    // Closed Service count
                    $closedServiceCount = AmcService::whereHas('serviceStatus', function ($q) {
                        $q->where(['value' => 'closed']);
                    })->whereHas('amc', function ($q) {
                        $q->where(['customer' => auth()->user()->id]);
                    })->count();

                    // Calendar data
                    $calendarData = array();
                    $calendarServiceData = AmcService::whereHas('amc', function ($q) {
                        $q->where(['customer' => auth()->user()->id]);
                    })->get();

                    foreach ($calendarServiceData as $service) {
                        $serviceTime = $service->service_time;
                        $serviceTime = str_replace(' GMT+0530 (India Standard Time)', '', $serviceTime);
                        $serviceTime = Carbon::parse($serviceTime)->format('H:i:s');

                        $data = array();
                        $data['id'] = $service->id;
                        $data['start'] = ($service->service_date && $service->service_time) ? date("Y-m-d", strtotime($service->service_date)) . 'T' . $serviceTime : "";
                        $data['title'] = 'Service (' . $service->service_no . ')';
                        $data['unique_no'] = $service->service_no;
                        $data['date'] = $service->service_date;
                        $data['color'] = '#009DFA';
                        $calendarData[] = $data;
                    }

                    $monthStartYmd = Carbon::now()->startOfMonth()->format('Y-m-d');
                    $monthEndYmd = Carbon::now()->endOfMonth()->format('Y-m-d');
                    $calendarComplaintData = Complaint::where(['customer_id' => auth()->user()->id])->whereBetween('assign_date', [$monthStartYmd, $monthEndYmd])->get();
                    foreach ($calendarComplaintData as $complaint) {
                        $complaintTime = $complaint->complaint_time;
                        $complaintTime = str_replace(' GMT+0530 (India Standard Time)', '', $complaintTime);
                        $complaintTime = Carbon::parse($complaintTime)->format('H:i:s');

                        $data = array();
                        $data['id'] = $complaint->id;
                        $data['start'] = ($complaint->assign_date && $complaint->complaint_time) ? $complaint->assign_date . 'T' . $complaintTime : "";
                        $data['title'] = 'Complaint (' . $complaint->complaint_no . ')';
                        $data['unique_no'] = $complaint->complaint_no;
                        $data['date'] = $complaint->assign_date;
                        $data['color'] = '#CF960B';
                        $calendarData[] = $data;
                    }

                    // Current month service
                    $monthAmcService = AmcService::whereHas('amc', function ($q) {
                        $q->where(['customer' => auth()->user()->id]);
                    })->whereBetween('service_date', [$monthStart, $monthEnd])->take(5)->get();

                    return response()->json([
                        'allComplaintCount' => $allComplaintCount,
                        'openComplaintCount' => $openComplaintCount,
                        'progressComplaintCount' => $progressComplaintCount,
                        'closedComplaintCount' => $closedComplaintCount,
                        'allQuotationCount' => $allQuotationCount,
                        'allSaleCount' => $allSaleCount,

                        'allServiceCount' => $allServiceCount,
                        'openServiceCount' => $openServiceCount,
                        'progressServiceCount' => $progressServiceCount,
                        'closedServiceCount' => $closedServiceCount,

                        'calendarData' => $calendarData,

                        'todayComplaints' => DashboardComplaintResource::collection($recentComplaints),
                        'currentMonthService' => DashboardServiceResource::collection($monthAmcService),
                        'weeklyComplaintData' => $weeklyComplaintData,
                        'weeklyServiceData' => $weeklyServiceData,
                    ], 200);
                } elseif (auth()->user()->getRole() == 'employee') {
                    $weeklyComplaintData = $this->getWeeklyComplaintData();
                    $weeklyServiceData = $this->getWeeklyServiceData();
                    // All Complaint count
                    $allComplaintCount = Complaint::where(['assign_to_id' => auth()->user()->id])->count();

                    // Open Complaint count
                    $openComplaintCount = Complaint::where(['assign_to_id' => auth()->user()->id])->whereHas('status', function ($q) {
                        $q->where(['value' => 'open']);
                    })->count();

                    // Inprogress complaint count    
                    $progressComplaintCount = Complaint::where(['assign_to_id' => auth()->user()->id])->whereHas('status', function ($q) {
                        $q->where(['value' => 'progress']);
                    })->count();

                    // Closed complaint count
                    $closedComplaintCount = Complaint::where(['assign_to_id' => auth()->user()->id])->whereHas('status', function ($q) {
                        $q->where(['value' => 'closed']);
                    })->count();

                    // Recent complain list
                    $recentComplaints = Complaint::where(['assign_to_id' => auth()->user()->id])->take(6)->Orderby('created_at', 'desc')->get();

                    // Smart Summary Data

                    // All Service count
                    $allServiceCount = AmcService::where(['assign_to' => auth()->user()->id])->count();

                    // Open Service count
                    $openServiceCount = AmcService::whereHas('serviceStatus', function ($q) {
                        $q->where(['value' => 'open']);
                    })->where(['assign_to' => auth()->user()->id])->count();

                    // Inprogress Service count    
                    $progressServiceCount = AmcService::whereHas('serviceStatus', function ($q) {
                        $q->where(['value' => 'progress']);
                    })->where(['assign_to' => auth()->user()->id])->count();

                    // Closed Service count
                    $closedServiceCount = AmcService::whereHas('serviceStatus', function ($q) {
                        $q->where(['value' => 'closed']);
                    })->where(['assign_to' => auth()->user()->id])->count();

                    // Calendar data
                    $calendarData = array();
                    $calendarServiceData = AmcService::where(['assign_to' => auth()->user()->id])->get();

                    foreach ($calendarServiceData as $service) {
                        $serviceTime = $service->service_time;
                        $serviceTime = str_replace(' GMT+0530 (India Standard Time)', '', $serviceTime);
                        $serviceTime = Carbon::parse($serviceTime)->format('H:i:s');

                        $data = array();
                        $data['id'] = $service->id;
                        $data['start'] = ($service->service_date && $service->service_time) ? date("Y-m-d", strtotime($service->service_date)) . 'T' . $serviceTime : "";
                        $data['title'] = 'Service (' . $service->service_no . ')';
                        $data['unique_no'] = $service->service_no;
                        $data['date'] = $service->service_date;
                        $data['color'] = '#009DFA';
                        $calendarData[] = $data;
                    }

                    $monthStartYmd = Carbon::now()->startOfMonth()->format('Y-m-d');
                    $monthEndYmd = Carbon::now()->endOfMonth()->format('Y-m-d');
                    $calendarComplaintData = Complaint::where(['assign_to_id' => auth()->user()->id])->whereBetween('assign_date', [$monthStartYmd, $monthEndYmd])->get();
                    foreach ($calendarComplaintData as $complaint) {
                        $complaintTime = $complaint->complaint_time;
                        $complaintTime = str_replace(' GMT+0530 (India Standard Time)', '', $complaintTime);
                        $complaintTime = Carbon::parse($complaintTime)->format('H:i:s');

                        $data = array();
                        $data['id'] = $complaint->id;
                        $data['start'] = ($complaint->assign_date && $complaint->complaint_time) ? $complaint->assign_date . 'T' . $complaintTime : "";
                        $data['title'] = 'Complaint (' . $complaint->complaint_no . ')';
                        $data['unique_no'] = $complaint->complaint_no;
                        $data['date'] = $complaint->assign_date;
                        $data['color'] = '#CF960B';
                        $calendarData[] = $data;
                    }

                    // Current month service
                    $monthAmcService = AmcService::where(['assign_to' => auth()->user()->id])->whereBetween('service_date', [$monthStart, $monthEnd])->take(5)->get();

                    return response()->json([
                        'allComplaintCount' => $allComplaintCount,
                        'openComplaintCount' => $openComplaintCount,
                        'progressComplaintCount' => $progressComplaintCount,
                        'closedComplaintCount' => $closedComplaintCount,

                        'allServiceCount' => $allServiceCount,
                        'openServiceCount' => $openServiceCount,
                        'progressServiceCount' => $progressServiceCount,
                        'closedServiceCount' => $closedServiceCount,

                        'calendarData' => $calendarData,

                        'todayComplaints' => DashboardComplaintResource::collection($recentComplaints),
                        'currentMonthService' => DashboardServiceResource::collection($monthAmcService),
                        'weeklyComplaintData' => $weeklyComplaintData,
                        'weeklyServiceData' => $weeklyServiceData,
                    ], 200);
                } else {
                    $weeklyComplaintData = $this->getWeeklyComplaintData();
                    $weeklyServiceData = $this->getWeeklyServiceData();
                    // All data counts
                    $employeeCount = User::role('employee')->count();
                    $customerCount = User::role('customer')->count();
                    $amcCount = Amc::count();
                    $complainCount = Complaint::count();
                    // $complainCountForChart = Complaint::whereIn('status_id', [28, 30])->count();
                    $complainCountForChart = Complaint::whereHas('status', function ($q) {
                        $q->whereIn('value', ['open', 'closed']);
                    })->count();
                    $productCount = Product::count();
                    $serviceCount = AmcService::count();
                    // $serviceCountForChart = AmcService::whereIn('status', [17, 19])->count();
                    $serviceCountForChart = AmcService::whereHas('serviceStatus', function ($q) {
                        $q->whereIn('value', ['open', 'closed']);
                    })->count();

                    // Open Complaint count
                    $openComplaintCount = Complaint::whereHas('status', function ($q) {
                        $q->where(['value' => 'open']);
                    })->count();

                    // Inprogress complaint count    
                    $progressComplaintCount = Complaint::whereHas('status', function ($q) {
                        $q->where(['value' => 'progress']);
                    })->count();

                    // Closed complaint count
                    $closedComplaintCount = Complaint::whereHas('status', function ($q) {
                        $q->where(['value' => 'closed']);
                    })->count();

                    // Open Service count
                    $openServiceCount = AmcService::whereHas('serviceStatus', function ($q) {
                        $q->where(['value' => 'open']);
                    })->count();

                    // Inprogress Service count    
                    $progressServiceCount = AmcService::whereHas('serviceStatus', function ($q) {
                        $q->where(['value' => 'progress']);
                    })->count();

                    // Closed Service count
                    $closedServiceCount = AmcService::whereHas('serviceStatus', function ($q) {
                        $q->where(['value' => 'closed']);
                    })->count();

                    $today = Carbon::today();

                    $totalComplaints = Complaint::count();

                    // Get delayed complaints count
                    $delayedComplaintsCount = Complaint::where('assign_date', '<', $today)
                        ->where('status_id', '!=', '30')
                        ->count();

                    $ontimeComplaintsCount = $totalComplaints - $delayedComplaintsCount;

                    if ($totalComplaints) {
                        $ontimeComplaintPer = ($ontimeComplaintsCount / $totalComplaints) * 100;
                        $ontimeComplaintPer = number_format((float) $ontimeComplaintPer, 0, '.', '');
                        $delayedComplaintPer = ($delayedComplaintsCount / $totalComplaints) * 100;
                        $delayedComplaintPer = number_format((float) $delayedComplaintPer, 0, '.', '');
                    } else {
                        $ontimeComplaintPer = 0;
                        $delayedComplaintPer = 0;
                    }
                    $delayedComplaintChartData = array();
                    $delayedComplaintChartData[0]['name'] = "$ontimeComplaintPer% On Time Complaint";
                    $delayedComplaintChartData[0]['value'] = $ontimeComplaintPer;
                    $delayedComplaintChartData[0]['status'] = 'ontime';

                    $delayedComplaintChartData[1]['name'] = "$delayedComplaintPer% Delayed Complaint";
                    $delayedComplaintChartData[1]['value'] = $delayedComplaintPer;
                    $delayedComplaintChartData[1]['status'] = 'delayed ';

                    $totalServices = AmcService::count();

                    // Get delayed services count
                    $delayedServicesCount = AmcService::where('service_date', '<', $today)
                        ->where('status', '!=', '19')
                        ->count();

                    $ontimeServicesCount = $totalServices - $delayedServicesCount;

                    if ($totalServices) {
                        $ontimeServicePer = ($ontimeServicesCount / $totalServices) * 100;
                        $ontimeServicePer = number_format((float) $ontimeServicePer, 0, '.', '');
                        $delayedServicePer = ($delayedServicesCount / $totalServices) * 100;
                        $delayedServicePer = number_format((float) $delayedServicePer, 0, '.', '');
                    } else {
                        $ontimeServicePer = 0;
                        $delayedServicePer = 0;
                    }
                    $delayedServiceChartData = array();
                    $delayedServiceChartData[0]['name'] = "$ontimeServicePer% On Time Service";
                    $delayedServiceChartData[0]['value'] = $ontimeServicePer;
                    $delayedServiceChartData[0]['status'] = 'ontime';

                    $delayedServiceChartData[1]['name'] = "$delayedServicePer% Delayed Service";
                    $delayedServiceChartData[1]['value'] = $delayedServicePer;
                    $delayedServiceChartData[1]['status'] = 'delayed';
                    // Complaint Chart data

                    if ($complainCountForChart) {
                        $openComplainPer = ($openComplaintCount / $complainCountForChart) * 100;
                        $openComplainPer = number_format((float)$openComplainPer, 0, '.', '');
                        $closedComplainPer = ($closedComplaintCount / $complainCountForChart) * 100;
                        $closedComplainPer = number_format((float)$closedComplainPer, 0, '.', '');
                    } else {
                        $openComplainPer = 0;
                        $closedComplainPer = 0;
                    }
                    $complaintChartData = array();
                    $complaintChartData[0]['name'] = "$openComplainPer% Open Complaint";
                    $complaintChartData[0]['value'] = $openComplainPer;
                    $complaintChartData[0]['status'] = 'open';

                    $complaintChartData[1]['name'] = "$closedComplainPer% Closed Complaint";
                    $complaintChartData[1]['value'] = $closedComplainPer;
                    $complaintChartData[1]['status'] = 'closed';

                    // Service chart data

                    if ($serviceCountForChart) {
                        $openServicePer = ($openServiceCount / $serviceCountForChart) * 100;
                        $openServicePer = number_format((float)$openServicePer, 0, '.', '');
                        $closedServicePer = ($closedServiceCount / $serviceCountForChart) * 100;
                        $closedServicePer = number_format((float)$closedServicePer, 0, '.', '');
                    } else {
                        $openServicePer = 0;
                        $closedServicePer = 0;
                    }

                    $serviceChartData = array();
                    $serviceChartData[0]['name'] = "$openServicePer% Open Service";
                    $serviceChartData[0]['value'] = $openServicePer;
                    $serviceChartData[0]['status'] = 'open';

                    $serviceChartData[1]['name'] = "$closedServicePer% Close Service";
                    $serviceChartData[1]['value'] = $closedServicePer;
                    $serviceChartData[1]['status'] = 'closed';

                    // Calendar data
                    $calendarData = array();
                    $calendarServiceData = AmcService::all();
                    foreach ($calendarServiceData as $service) {
                        $serviceTime = $service->service_time;
                        $serviceTime = str_replace(' GMT+0530 (India Standard Time)', '', $serviceTime);
                        $serviceTime = Carbon::parse($serviceTime)->format('H:i:s');

                        $data = array();
                        $data['id'] = $service->id;
                        $data['start'] = ($service->service_date && $service->service_time) ? date("Y-m-d", strtotime($service->service_date)) . 'T' . $serviceTime : "";
                        $data['title'] = 'Service (' . $service->service_no . ')';
                        $data['unique_no'] = $service->service_no;
                        $data['date'] = $service->service_date;
                        $data['color'] = '#009DFA';
                        $calendarData[] = $data;
                    }

                    $monthStartYmd = Carbon::now()->startOfMonth()->format('Y-m-d');
                    $monthEndYmd = Carbon::now()->endOfMonth()->format('Y-m-d');
                    $calendarComplaintData = Complaint::whereBetween('assign_date', [$monthStartYmd, $monthEndYmd])->get();
                    foreach ($calendarComplaintData as $complaint) {
                        $complaintTime = $complaint->complaint_time;
                        $complaintTime = str_replace(' GMT+0530 (India Standard Time)', '', $complaintTime);
                        $complaintTime = Carbon::parse($complaintTime)->format('H:i:s');

                        $data = array();
                        $data['id'] = $complaint->id;
                        $data['start'] = ($complaint->assign_date && $complaint->complaint_time) ? $complaint->assign_date . 'T' . $complaintTime : "";
                        $data['title'] = 'Complaint (' . $complaint->complaint_no . ')';
                        $data['unique_no'] = $complaint->complaint_no;
                        $data['date'] = $complaint->assign_date;
                        $data['color'] = '#CF960B';
                        $calendarData[] = $data;
                    }

                    $calendarTaskData = Task::whereBetween('date', [$monthStartYmd, $monthEndYmd])->get();
                    foreach ($calendarTaskData as $task) {
                        $data = array();
                        $data['id'] = $task->id;
                        $data['title'] = 'Task';
                        $data['date'] = $task->date;
                        $data['color'] = '#FF2351';
                        $calendarData[] = $data;
                    }

                    // Today Complaint
                    $todayComplaints = Complaint::take(6)->Orderby('created_at', 'desc')->get();


                    // Current month service
                    $monthAmcService = AmcService::whereBetween('service_date', [$monthStart, $monthEnd])->take(5)->get();

                    return response()->json([
                        'totalEmployee' => $employeeCount,
                        'totalCustomer' => $customerCount,
                        'totalAmc' => $amcCount,
                        'totalComplaint' => $complainCount,
                        'totalProduct' => $productCount,
                        'totalService' => $serviceCount,

                        'openComplaintCount' => $openComplaintCount,
                        'progressComplaintCount' => $progressComplaintCount,
                        'closedComplaintCount' => $closedComplaintCount,

                        'openServiceCount' => $openServiceCount,
                        'progressServiceCount' => $progressServiceCount,
                        'closedServiceCount' => $closedServiceCount,

                        'complaintChartData' => $complaintChartData,
                        'serviceChartData' => $serviceChartData,
                        'calendarData' => $calendarData,

                        'todayComplaints' => DashboardComplaintResource::collection($todayComplaints),
                        'currentMonthService' => DashboardServiceResource::collection($monthAmcService),
                        'weeklyComplaintData' => $weeklyComplaintData,
                        'weeklyServiceData' => $weeklyServiceData,
                        'delayedComplaintChartData' => $delayedComplaintChartData,
                        'delayedServiceChartData' => $delayedServiceChartData,
                    ], 200);
                }
            } else {
                $data = [
                    'error' => true,
                    'message' => 'Unauthorized',
                    'error_code' => 401
                ];
                return response()->json($data, 401);
            }
        } catch (UserNotDefinedException $e) {
            $this->setResponse(true, $e->getMessage());
            return response()->json($this->_response, 500);
        }
    }

    public function sidemenu()
    {
        try {
            $roleData = Role::all()->load('permissions');
            return SidemenuResource::collection($roleData)->additional(["error" => false, "message" => 'Here is all sidemenu data accourding access rights']);
        } catch (UserNotDefinedException $e) {
            $this->setResponse(true, $e->getMessage());
            return response()->json($this->_response, 500);
        }
    }
    private function getWeeklyComplaintData()
    {
        $now = Carbon::now();
        $daysOfWeek = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'];
        $weeklyComplaintData = [];
    
        foreach ($daysOfWeek as $day) {
            $startOfDay = $now->startOfWeek()->modify($day);
            $endOfDay = $startOfDay->copy()->endOfDay();
    
            // Adjust the start of the week if the current day is after the day of the week
            if ($now->gt($endOfDay)) {
                $startOfDay->addWeek();
                $endOfDay->addWeek();
            }
    
            $openComplaints = Complaint::whereBetween('assign_date', [$startOfDay, $endOfDay])
                ->whereHas('status', function ($q) {
                    $q->where(['value' => 'open']);
                })->count();
    
            $closedComplaints = Complaint::whereBetween('assign_date', [$startOfDay, $endOfDay])
                ->whereHas('status', function ($q) {
                    $q->where(['value' => 'closed']);
                })->count();
    
            $weeklyComplaintData[] = [
                'day' => $day,
                'date' => $startOfDay->format('d-m-Y'),
                'open' => $openComplaints,
                'closed' => $closedComplaints,
            ];
        }
    
        return $weeklyComplaintData;
    }
    

    private function getWeeklyServiceData()
    {
        $now = Carbon::now();
        $daysOfWeek = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'];
        $weeklyServiceData = [];

        foreach ($daysOfWeek as $day) {
            $startOfDay = $now->startOfWeek()->modify($day);
            $endOfDay = $startOfDay->copy()->endOfDay();

            // Adjust the start of the week if the current day is after the day of the week
            if ($now->gt($endOfDay)) {
                $startOfDay->addWeek();
                $endOfDay->addWeek();
            }

            $openServices = AmcService::whereBetween('service_date', [$startOfDay, $endOfDay])
                ->whereHas('serviceStatus', function ($q) {
                    $q->where(['value' => 'open']);
                })->count();

            $closedservices = AmcService::whereBetween('service_date', [$startOfDay, $endOfDay])
                ->whereHas('serviceStatus', function ($q) {
                    $q->where(['value' => 'closed']);
                })->count();

            $weeklyServiceData[] = [
                'day' => $day,
                'date' => $startOfDay->format('d-m-Y'),
                'open' => $openServices,
                'closed' => $closedservices,
            ];
        }

        return $weeklyServiceData;
    }
}
