<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Laravel\Lumen\Routing\Controller as BaseController;

class Controller extends BaseController
{
    protected $_response = ["data" => [], "error" => false, "message" => null, "error_code" => null];

    protected function setResponse($status = true, $message = null, $errorCode = null)
    {
        $this->_response['error'] = $status;
        $this->_response['message'] = $message;
        $this->_response['error_code'] = $errorCode;
    }

    protected function uploadFile($file,  $path = "no-path/attachments/")
    {
        $path = Str::finish($path, '/');

        if (!empty($file)) {
            return $this->uploadSingleFile($file, $path);
        }

        return false;
    }

    private function uploadSingleFile($file,  $path = "no-path/attachments/", $key = null)
    {
        $fileFullName = $file->getClientOriginalName();
        $fileName = str_replace(' ', '_', pathinfo($fileFullName, PATHINFO_FILENAME));
        $filePath = $path . $fileName . '-' . getUniqueStamp() . $key . '.' . $file->extension();
        $file->storeAs('public', $filePath);
        return $filePath;
    }
}
