<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Resources\UserResource;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\PermissionResource;
use App\Models\License;

class AuthController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth', ['except' => ['login', 'register',]]);
    }

    /**
     * Attempt to register a new user to the API.
     *
     * @param  Request  $request
     * @return Response
     */
    public function register(Request $request)
    {
        // Are the propr fields present?
        $this->validate($request, [
            'email' => 'required|string|email|max:100|unique:users',
            'password' => 'required|string|min:6',
        ]);

        try {
            $user = new User;
            $user->email = $request->input('email');
            // $user->password = app('hash')->make($plainPassword);
            $user->password = $request->input('password');

            $user->save();

            //return successful response
            return response()->json(['user' => $user, 'message' => 'CREATED'], 201);
        } catch (\Exception $e) {
            //return error message
            return response()->json(['message' => $e->getMessage()], 409);
        }
    }

    /**
     * Attempt to authenticate the user and retrieve a JWT.
     * Note: The API is stateless. This method _only_ returns a JWT. There is not an 
     * indicator that a user is logged in otherwise (no sessions).
     *
     * @param  Request  $request
     * @return Response
     */
    public function login(Request $request)
    {
        // Are the proper fields present?
        $this->validate($request, [
            'email' => 'required|string',
            'password' => 'required|string',
            'device_token' =>'string',
        ]);

        $credentials = $request->only(['email', 'password']);

        if (!$token = Auth::attempt($credentials)) {
            $this->setResponse(true, 'Invalid credentials.', '401');
            return response()->json($this->_response, 200);
        }

        $license = License::latest()->first();
        // $active_url = $license->app_url;
        $active_url = parse_url($request->root())['host'] || $license->app_url;
        $whitelist = [
            // IPv4 address
            '127.0.0.1',
            'localhost',
            'amc_api_laravel.test',
            '192.168.1.77',
            'amc.3dlif.com',
            // IPv6 address
            '::1'
        ];
        if (!in_array($active_url, $whitelist)) {
        // Get License Data

        $api_server = 'license.dasinfomedia.com';
        $fp = @fsockopen($api_server, 80, $errno, $errstr, 2);
        if (!$fp) {
            $server_rerror = 'Down';
        } else {
            $server_rerror = "up";
        }

        if ($server_rerror == "up") {
        // Verify License
        if ($license) {
            $url = 'http://license.dasinfomedia.com/index.php';
            $fields = [
                'result' => '2',
                // 'domain' => $license->app_url,
                'domain' => $active_url,
                'licence_key' => $license->app_license_key,
                'email' => $license->app_email,
                'item_name' => 'gym_master',
            ];

            // Open connection
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));

            $chResult = curl_exec($ch);
            curl_close($ch);
            $result = $chResult;

            // Check License Verification Result
            if ($result == '1') {
                $this->setResponse(true, "!Please enter correct purchase key.");
                return response()->json($this->_response, 400);
            } elseif ($result == '2') {
                $this->setResponse(true, "!This purchase key is already registered with the different domain. If you have any issue please contact us at sales@dasinfomedia.com");
                return response()->json($this->_response, 400);
            } elseif ($result == '3') {
                $this->setResponse(true, "!There seems to be some problem please try after sometime or contact us on sales@dasinfomedia.com");
                return response()->json($this->_response, 400);
            } elseif ($result == '4') {
                $this->setResponse(true, "!Please enter correct purchase key for this plugin.");
                return response()->json($this->_response, 400);
            }
        }
    }else {
        $this->setResponse(true, "!Connection Problem occurs because server is down.");
        return response()->json($this->_response, 400);
    }
    }
// If device_token is present in the request, update it for the logged-in user
if ($request->has('device_token')) {
    $user = Auth::user();
    $user->device_token = $request->input('device_token');
    $user->save();
}
        // Valid Login, return token
        // return $this->respondWithToken(Auth::user(), Auth::attempt($credentials));
        return $this->respondWithToken($token);
    }

    /**
     * Log the user out (Invalidate the token). Requires a login to use as the
     * JWT in the Authorization header is what is invalidated
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function logout()
    {
        auth()->logout();

        return response()->json(['message' => 'User successfully signed out']);
    }

    /**
     * Refresh the current token.
     * 
     * @return \Illuminate\Http\JsonResponse
     */
    public function refresh()
    {
        return $this->respondWithToken(auth()->refresh());
    }

    /**
     * Helper function to format the response with the token.
     * 
     * @return \Illuminate\Http\JsonResponse
     */
    private function respondWithToken($token)
    {
        return response()->json([
            'user' => (new UserResource(auth()->user())),
            'accessToken' => $token,
            'permissions' => PermissionResource::collection(auth()->user()->getAllPermissions()),
            'token_type' => 'bearer',
            'expires_in' => Auth::factory()->getTTL() * 60
        ], 200);
    }

    /**
     * Store a new user.
     *
     * @param  Request  $request
     * @return Response
     */
    public function profile(Request $request)
    {
        try {

            return response()->json([
                'user' => array('name' => 'Vijay Parmar', 'role' => 'SA'),
            ], 200);
        } catch (\Exception $e) {
            //return error message
            $this->setResponse(true,  $e->getMessage());
            return response()->json($this->_response, 500);
        }
    }
}
